package com.android.print.demo;

import android.Manifest;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;

import com.android.print.demo.utils.PrintUtils;
import com.mht.print.sdk.PrinterConstants;
import com.mht.print.sdk.PrinterInstance;
import com.mht.print.sdk.TsplCommand;
import com.mht.print.sdk.util.Utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MainActivity extends Activity implements OnClickListener {

    private static long lastClickTime;

    private static String TAG = MainActivity.class.getSimpleName();

    private Context mContext;
    private ImageView imageView;
    private Button btnBluetooth, btnWifi, btnUsb;
    private int offset = 0;
    private int currIndex = 0;//  0--bluetooth,1--wifi,2--usb
    private int bmpW;

    private boolean showUSB; //before android3.0 don't show usb
    private static boolean isConnected;
    private IPrinterOpertion myOpertion;
    private PrinterInstance mPrinter;

    // Intent request codes
    public static final int CONNECT_DEVICE = 1;
    public static final int ENABLE_BT = 2;

    private Button connectButton;
    private Button printImage;

    private Button printText;
    private Button printTable;

    private Button printBarCode;
    private Button printQRCodeImage;
    private Button printQRCodeCommand;
    private Button bothPrint;

    private RadioButton printer_type_receipt;
    private RadioButton printer_type_label;

    private boolean isReceipt = true;
    private ProgressDialog dialog;

    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    //读写权限
    private static String[] PERMISSIONS_STORAGE = {
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE};
    //请求状态码
    private static int REQUEST_PERMISSION_CODE = 1;


    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        showUSB = Build.VERSION.SDK_INT > Build.VERSION_CODES.GINGERBREAD_MR1;
        mContext = this;
        PrintUtils.context = mContext;
        initView();
        initImageView();
        //高版本安卓，搜索蓝牙需要获取定位权限
        //For high version Android, you need to obtain location permission to search for Bluetooth
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.P) {
            Log.i(TAG, "sdk < 28 Q");
            if (ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                    || ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                String[] strings =
                        {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION};
                ActivityCompat.requestPermissions(this, strings, REQUEST_PERMISSION_CODE);
            }
        } else {
            if (ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                    || ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED
                    || ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.ACCESS_BACKGROUND_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                String[] strings = {android.Manifest.permission.ACCESS_FINE_LOCATION,
                        android.Manifest.permission.ACCESS_COARSE_LOCATION,
                        Manifest.permission.ACCESS_BACKGROUND_LOCATION};
                ActivityCompat.requestPermissions(this, strings, 2);
            }
        }


        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP) {
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this, PERMISSIONS_STORAGE, REQUEST_PERMISSION_CODE);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUEST_PERMISSION_CODE) {
            for (int i = 0; i < permissions.length; i++) {
                Log.i("MainActivity", "申请的权限为：" + permissions[i] + ",申请结果：" + grantResults[i]);
            }
        }
    }

    @SuppressWarnings("all")
    private void initView() {
        connectButton =

                findViewById(R.id.connect);
        connectButton.setOnClickListener(this);

        printer_type_receipt =

                findViewById(R.id.type_receipt);
        printer_type_receipt.setOnClickListener(this);
        printer_type_label =

                findViewById(R.id.type_label);
        printer_type_label.setOnClickListener(this);

        printText =

                findViewById(R.id.btnPrintText);
        printText.setOnClickListener(this);
        printBarCode =

                findViewById(R.id.btnPrintBarCode);

        printQRCodeImage =

                findViewById(R.id.btnPrintQrCodeImage);
        printQRCodeImage.setOnClickListener(this);
        printQRCodeCommand =

                findViewById(R.id.btnPrintQrCodeCommand);
        printQRCodeCommand.setOnClickListener(this);
        printBarCode.setOnClickListener(this);
        printImage =

                findViewById(R.id.btnPrintImage);
        printImage.setOnClickListener(this);
        printTable =

                findViewById(R.id.btnPrintTable);
        printTable.setOnClickListener(this);


        btnBluetooth =

                findViewById(R.id.btnBluetooth);
        btnBluetooth.setOnClickListener(this);

        btnWifi =

                findViewById(R.id.btnWifi);
        btnWifi.setOnClickListener(this);

        btnUsb =

                findViewById(R.id.btnUsb);
        if (showUSB) {
            btnUsb.setOnClickListener(this);
        } else {
            btnUsb.setVisibility(View.GONE);
        }

        dialog = new

                ProgressDialog(mContext);
        dialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        dialog.setTitle("Connecting...");
        dialog.setMessage("Please Wait...");
        dialog.setIndeterminate(true);
        dialog.setCancelable(false);

        setTitleTextColor(0);

    }


    private void updateButtonState() {
        if (!isConnected) {
            String connStr = getResources().getString(R.string.connect);
            switch (currIndex) {
                case 0:
                    connStr = String.format(connStr, btnBluetooth.getText());
                    break;
                case 1:
                    connStr = String.format(connStr, btnWifi.getText());
                    break;
                case 2:
                    connStr = String.format(connStr, btnUsb.getText());
                    break;
                default:
                    break;
            }
            connectButton.setText(connStr);
        } else {
            connectButton.setText(R.string.disconnect);
        }
        btnBluetooth.setEnabled(!isConnected);
        btnWifi.setEnabled(!isConnected);
        btnUsb.setEnabled(!isConnected);

        printText.setEnabled(isConnected);
        printBarCode.setEnabled(isConnected);
        printQRCodeImage.setEnabled(isConnected);
        printQRCodeCommand.setEnabled(isConnected);
        printImage.setEnabled(isConnected);
        printTable.setEnabled(isConnected);
    }

    @Override
    protected void onActivityResult(final int requestCode, int resultCode, final Intent data) {
        switch (requestCode) {
            case CONNECT_DEVICE:
                if (resultCode == Activity.RESULT_OK) {
                    dialog.show();
                    /*new Thread(() -> {
                        for (int i = 0; i < 3; i++) {
                            myOpertion.open(data);
                            try {
                                Thread.sleep(1000);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();*/
                    myOpertion.open(data);
                }
                break;
            case ENABLE_BT:
                if (resultCode == Activity.RESULT_OK) {
                    myOpertion.chooseDevice();
                } else {
                    Toast.makeText(this, R.string.bt_not_enabled, Toast.LENGTH_SHORT).show();
                }
            default:
                break;
        }
    }

    private void initImageView() {
        imageView = findViewById(R.id.cursor);
        DisplayMetrics dm = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        bmpW = BitmapFactory.decodeResource(getResources(), R.drawable.slide1)
                .getWidth();
        offset = (screenW / (btnUsb.getVisibility() == View.VISIBLE ? 3 : 2) - bmpW - 4) / 2;
        Matrix matrix = new Matrix();
        matrix.postTranslate(offset, 0);
        imageView.setImageMatrix(matrix);
    }

    public void onPageSelected(View view) {
        int index;
        if (view == btnBluetooth) {
            index = 0;
        } else if (view == btnWifi) {
            index = 1;
        } else {
            index = 2;
        }

        int one = offset * 2 + bmpW;

        Animation animation = new TranslateAnimation(one * currIndex, one * index, 0, 0);
        currIndex = index;
        animation.setFillAfter(true);
        animation.setDuration(300);
        imageView.startAnimation(animation);
        setTitleTextColor(index);
    }

    private void setTitleTextColor(int index) {
        switch (index) {
            case 0:
                btnBluetooth.setTextColor(Color.BLUE);
                btnWifi.setTextColor(Color.BLACK);
                btnUsb.setTextColor(Color.BLACK);
                break;
            case 1:
                btnBluetooth.setTextColor(Color.BLACK);
                btnWifi.setTextColor(Color.BLUE);
                btnUsb.setTextColor(Color.BLACK);
                break;
            case 2:
                btnBluetooth.setTextColor(Color.BLACK);
                btnWifi.setTextColor(Color.BLACK);
                btnUsb.setTextColor(Color.BLUE);
                break;

            default:
                break;
        }
        updateButtonState();
    }

    private void openConn() {
        if (!isConnected) {
            switch (currIndex) {
                // bluetooth
                case 0:
                    myOpertion = new BluetoothOperation(MainActivity.this, mHandler);
                    break;
                //wifi
                case 1:
                    myOpertion = new WifiOperation(MainActivity.this, mHandler);
                    break;
                // usb
                case 2:
                    myOpertion = new UsbOperation(MainActivity.this, mHandler);
                    break;
                default:
                    break;
            }

            myOpertion.chooseDevice();
        } else {
            myOpertion.close();
            myOpertion = null;
            mPrinter = null;
        }
    }

    private final Handler mHandler = new Handler(Looper.myLooper()) {

        @Override
        public void dispatchMessage(@NonNull Message msg) {
            super.dispatchMessage(msg);
            switch (msg.what) {
                case PrinterConstants.Connect.SUCCESS:
                    isConnected = true;
                    mPrinter = myOpertion.getPrinter();
                    break;
                case PrinterConstants.Connect.FAILED:
                    isConnected = false;
                    Toast.makeText(mContext, "connect failed...", Toast.LENGTH_SHORT).show();
                    break;
                case PrinterConstants.Connect.CLOSED:
                    isConnected = false;
                    Toast.makeText(mContext, "connect close...", Toast.LENGTH_SHORT).show();
                    break;
                default:
                    break;
            }

            updateButtonState();

            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
        }
    };

    @Override
    public void onClick(View view) {
        synchronized (MainActivity.class) {

            if (view == connectButton) {
                openConn();
            } else if (view == btnBluetooth || view == btnWifi || view == btnUsb) {
                onPageSelected(view);
            } else if (view == printer_type_receipt || view == printer_type_label) {
                isReceipt = view == printer_type_receipt;
                printer_type_receipt.setChecked(isReceipt);
                printer_type_label.setChecked(!isReceipt);
            } else {
                //Prevent repeated clicks
                if (checkDoubleClick()) {
                    Log.i(TAG, "Repeat click");
                    Toast.makeText(this, "Repeat click", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (view == printText) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            //打印小票
                            //Print Receipt Text
                            if (isReceipt) {
                                PrintUtils.printText(mContext.getResources(), mPrinter);
                                int printerStatus = mPrinter.getPrinterStatus();
                                String stateName = "查询失败";
                                switch (printerStatus) {
                                    case PrinterConstants.State.READY:
                                        stateName = "有纸";
                                        break;
                                    case PrinterConstants.State.OUT_OF_PAPER:
                                        stateName = "缺纸";
                                        break;
                                    default:
                                        break;
                                }
                                String finalStateName = stateName;
                                mHandler.post(() -> Toast.makeText(mContext, "打印机状态：" + finalStateName, Toast.LENGTH_SHORT).show());
                            } else {
                                //标签宽度
                                int labelWidth = 40;
                                //标签高度
                                int labelHeight = 30;
                                //先获取一个打印TSPL指令的实例，用于打印内容
                                TsplCommand tsplCommand = new TsplCommand();
                                //清除画板缓存，每打印一张新标签之前，都需要清除
                                tsplCommand.clearCanvas();
                                //定位标签纸大小（标签纸宽度和高度），单位mm
                                tsplCommand.initCanvas(labelWidth, labelHeight);
                                //设置打印方向（0和1，一正一反）
                                tsplCommand.setDirection(1);
                                //打印文字(普通)
                                tsplCommand.setText(0, 0, 1, 1, "123ABC横眉冷对千夫指");
                                tsplCommand.setText(0, 24, 1, 1, "希望是附丽于存在的，有存在，便有希望.");
                                tsplCommand.setText(8, 48, 1, 1, "123ABC横眉冷对千夫指");
                                tsplCommand.setText(8, 72, 1, 1, "希望是附丽于存在的，有存在，便有希望.");
                                //打印文字（居右）
                                //Print text (right)
                                //tsplCommand.setText(labelWidth, 48, 1, 1, 2, "123ABC横眉冷对千夫指");
                                //打印文字，文字的坐标定位采用坐标轴，坐标在标签纸上的计算单位转换是，1mm=8px
                                //When printing text, the coordinate positioning of the text adopts the coordinate axis, and the calculation unit conversion of the coordinate on the label paper is 1mm=8px
                                //tsplCommand.setText(0, 72, 1, 1, "希望是附丽于存在的，有存在，便有希望.");
                                //开始打印（参数是打印张数）
                                tsplCommand.setPrintNumber(1);
                                byte[] command = tsplCommand.getCommand();
                                mPrinter.sendByteData(command);
                            }
                        }
                    });
                } else if (view == printTable) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            //Print Table
                            if (isReceipt) {
                                boolean is58mm = false;
                                PrintUtils.printTable(mContext.getResources(), mPrinter, is58mm);
                            } else {
                                int labelWidth = 60;
                                int labelHeight = 30;
                                TsplCommand tsplCommand = new TsplCommand();
                                tsplCommand.clearCanvas();
                                tsplCommand.initCanvas(labelWidth, labelHeight);
                                tsplCommand.setDirection(1);
                                tsplCommand.setText(labelWidth, 0, 2, 2, 1, "福建省食用农产品合格证（散户）");
                                tsplCommand.setText(0, 50, 1, 1, "我承诺");
                                tsplCommand.setText(0, 80, 1, 1, "√ 没有使用禁用农药兽药");
                                tsplCommand.setBarCode(0, 114, "128", 48, 3, 2, 0, "123456");
                                tsplCommand.setPrintNumber(1);
                                mPrinter.sendByteData(tsplCommand.getCommand());
                            }
                        }
                    });
                } else if (view == printImage) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            if (isReceipt) {
                                PrintUtils.printImage(mContext.getResources(), mPrinter, isReceipt);
                            } else {
                                Bitmap bitmap = Utils.handleBitmap(BitmapFactory.decodeResource(mContext.getResources(),
                                        R.drawable.goodwork), 40 * 8, 30 * 8);
                                //第一种方式，打印一张图片，传入标签宽高和图片
                                //mPrinter.printLabelImage(40, 30, bitmap);
                                //第二种方式，打印一张图片，可定义打印方向，打印张数，打印位置。
                                //mPrinter.printLabelImage(40, 30, 1, 1, 0, 0, bitmap);
                                //第三种方式，构建所需的指令。比如一张标签上，绘制多张图片在不同的位置上。
                                TsplCommand tsplCommand = new TsplCommand();
                                tsplCommand.initCanvas(40, 30);
                                tsplCommand.clearCanvas();
                                tsplCommand.setDirection(0);
                                //bitmap的大小不能超过标签纸大小，根据1mm=8px来计算，如果超过，会导致bitmap打印不全，所以需要重置大小
                                //The size of the bitmap cannot exceed the size of the label paper. It is calculated according to 1mm=8px. If it exceeds, it will cause the bitmap to be incompletely printed, so it needs to be reset.
                                Bitmap bitmap2 = Utils.handleBitmap(BitmapFactory.decodeResource(mContext.getResources(),
                                        R.drawable.goodwork), 40 * 8, 30 * 8);
                                tsplCommand.setBitmap(0, 0, bitmap2);
                                tsplCommand.setPrintNumber(1);
                                mPrinter.printLabel(tsplCommand);
                                /*AssetManager am = getAssets();
                                StringBuilder hexString = new StringBuilder();
                                try {
                                    InputStream is = am.open("laiqiankuai.txt");
                                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                                    String line = br.readLine();
                                    while (line != null) {
                                        hexString.append(line);
                                        line = br.readLine();
                                    }
                                } catch (IOException e) {
                                    e.printStackTrace();
                                }
                                byte[] bytes = Utils.hex2byte(hexString.toString());
                                mPrinter.sendByteData(bytes);*/
                            }
                        }
                    });
                } else if (view == printBarCode) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            //Print barcode
                            if (isReceipt) {
                                PrintUtils.printBarCode(mPrinter);
                            } else {
                                TsplCommand tsplCommand = new TsplCommand();
                                tsplCommand.clearCanvas();
                                tsplCommand.initCanvas(60, 30);
                                tsplCommand.setDirection(0);
                                //打印条形码
                                //Print barcode
                                tsplCommand.setBarCode(0, 0, "128", 48, 1, 2, 0, "123456");
                                tsplCommand.setPrintNumber(1);
                                mPrinter.sendByteData(tsplCommand.getCommand());
                            }
                        }
                    });
                } else if (view == printQRCodeImage) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            //Print QrCode(by image)
                            if (isReceipt) {
                                PrintUtils.printQRCode(mContext.getResources(), mPrinter);
                            } else {
                                TsplCommand tsplCommand = new TsplCommand();
                                tsplCommand.clearCanvas();
                                tsplCommand.initCanvas(60, 30);
                                tsplCommand.setDirection(0);
                                //打印二维码
                                //Print QRCode
                                tsplCommand.setQrCode(0, 0, "L", 4, 0, "https://wwww.baidu.com");
                                tsplCommand.setPrintNumber(1);
                                mPrinter.sendByteData(tsplCommand.getCommand());
                            }
                        }
                    });
                } else if (view == printQRCodeCommand) {
                    singleThreadExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            if (isReceipt) {
                                PrintUtils.printQRCode(mPrinter);
                            } else {
                                TsplCommand tsplCommand = new TsplCommand();
                                tsplCommand.clearCanvas();
                                tsplCommand.initCanvas(60, 30);
                                tsplCommand.setDirection(0);
                                //打印二维码
                                //Print QRCode
                                tsplCommand.setQrCode(0, 0, "L", 4, 0, "测试二维码内容");
                                tsplCommand.setPrintNumber(1);
                                mPrinter.sendByteData(tsplCommand.getCommand());
                            }
                        }
                    });
                }
            }
        }
    }


    public static boolean checkDoubleClick() {
        //Click time
        long clickTime = SystemClock.uptimeMillis();
        //If the current click interval is less than 1000 milliseconds
        if (lastClickTime >= clickTime - 1000) {
            lastClickTime = clickTime;
            return true;
        }
        //Record the last click time
        lastClickTime = clickTime;
        return false;

    }

}